/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;

public class AtmPortPollAction
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.jdm8273.Rs8273Resources";
    private static String AtmPortStatusTableName = "AtmPortStatusTableName";
    private static String AtmPortStatusItemName = "AtmPortStatusItemName";
    private static String AtmPortStatusUnknown = "AtmPortStatusUnknown";
    private static String AtmPortStatusNotInService = "AtmPortStatusNotInService";
    private static String AtmPortStatusLoopback = "AtmPortStatusLoopback";
    private static String AtmPortStatusDown = "AtmPortStatusDown";
    private static String AtmPortStatusDisabled = "AtmPortStatusDisabled";

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, AtmPortStatusTableName);
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, AtmPortStatusItemName, objectArray);
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        StatusAndExplain statusAndExplain;
        if (statusModelInfo == null) {
            return;
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        if (!(statusModelInfo.get("AtmxPortStatus.PhyPortAdmStatus") instanceof Integer && statusModelInfo.get("AtmxPortStatus.PhyPortOperStatus") instanceof Integer && statusModelInfo.get("AtmxPortStatus.AtmxPortOperStatus") instanceof Integer)) {
            statusAndExplain = new StatusAndExplain();
            statusAndExplain.statType = StatusType.UNKNOWN;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, AtmPortStatusUnknown, objectArray);
        } else {
            int n = (Integer)statusModelInfo.get("AtmxPortStatus.PhyPortAdmStatus");
            int n2 = (Integer)statusModelInfo.get("AtmxPortStatus.PhyPortOperStatus");
            int n3 = (Integer)statusModelInfo.get("AtmxPortStatus.AtmxPortOperStatus");
            statusAndExplain = this.evaluateAtmAdminOper(n, n2, n3, objectArray);
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    private StatusAndExplain evaluateAtmAdminOper(int n, int n2, int n3, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        statusAndExplain.statType = StatusType.UNKNOWN;
        statusAndExplain.explain = new I18NMsgFormat(bundleName, AtmPortStatusUnknown, objectArray);
        if (n == 2 && n2 == 3 && n3 == 2) {
            statusAndExplain.statType = StatusType.NORMAL;
            statusAndExplain.explain = null;
        } else if (n == 2 && n2 == 3) {
            statusAndExplain.statType = StatusType.MARGINAL;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, AtmPortStatusNotInService, objectArray);
        } else if (n == 2 && n3 == 4) {
            statusAndExplain.statType = StatusType.MARGINAL;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, AtmPortStatusLoopback, objectArray);
        } else if (n == 2 && n2 == 2) {
            statusAndExplain.statType = StatusType.CRITICAL;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, AtmPortStatusDown, objectArray);
        } else if (n == 1) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            statusAndExplain.explain = new I18NMsgFormat(bundleName, AtmPortStatusDisabled, objectArray);
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NMsgFormat explain;

        StatusAndExplain() {
            AtmPortPollAction.this = AtmPortPollAction.this;
        }
    }
}

